
#ifndef _1_CRYS_ATP_TST_RSA_Acceptance_h_H
#define _1_CRYS_ATP_TST_RSA_Acceptance_h_H



/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_ATP_TST_Defines.h"
#if TST_USE_RSA_DATA/*In case no test vectors are selected - code disabled*/

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Wed Jan 12 12:18:08 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_RSA_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/******** Defines **********/
/******** Enums ************/
/******** Typedefs  **********/
/******** Structs  **********/
typedef struct TST_RSA_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
    DxUint8_t					TST_PrivetExponent_D[TST_MAX_PRVT_EXP_SIZE_IN_BYTES];
    DxUint8_t					TST_PublicExponent_E[TST_MAX_PUB_EXP_SIZE_IN_BYTES];
    DxUint8_t					TST_Modulus_N[TST_MAX_MOD_SIZE_IN_BYTES];
	DxUint8_t					TST_P[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2]; 
	DxUint8_t					TST_Q[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];  	   
	DxUint8_t					TST_dP[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint8_t					TST_dQ[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint8_t					TST_Qinv[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];		  	
    DxUint16_t					TST_KeySize;
    DxUint16_t					TST_DPSize;
    DxUint16_t					TST_PubExponentSize; 
	DxUint8_t 					TST_input_data[TST_MAX_PRVT_EXP_SIZE_IN_BYTES];	
	DxUint8_t 					TST_output_data[TST_MAX_PRVT_EXP_SIZE_IN_BYTES];	
	DxUint8_t 					TST_Expected_output_data[TST_MAX_PRVT_EXP_SIZE_IN_BYTES];	      
} TST_RSA_TestDataStruct;

typedef struct TST_RSA_TestSignVerifyDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
    DxUint8_t					TST_PrivetExponent_D[TST_MAX_PRVT_EXP_SIZE_IN_BYTES];
    DxUint8_t					TST_PublicExponent_E[TST_MAX_PUB_EXP_SIZE_IN_BYTES];
    DxUint8_t					TST_Modulus_N[TST_MAX_MOD_SIZE_IN_BYTES];
	DxUint8_t					TST_P[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2]; 
	DxUint8_t					TST_Q[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];  	   
	DxUint8_t					TST_dP[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint8_t					TST_dQ[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint8_t					TST_Qinv[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];		  	
    DxUint16_t					TST_KeySize;
    DxUint16_t					TST_DPSize; 
    DxUint16_t					TST_PubExponentSize; 
    DxUint16_t					TST_SaltLength;
	DxUint8_t 					TST_input_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
	DxUint16_t 					TST_input_dataSize;
	DxUint8_t 					TST_output_signiture[TST_MAX_PRVT_EXP_SIZE_IN_BYTES];	      
} TST_RSA_TestSignVerifyDataStruct;

typedef struct TST_RSA_TestExtHashSignVerifyDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
    DxUint8_t					TST_PrivetExponent_D[TST_MAX_PRVT_EXP_SIZE_IN_BYTES];
    DxUint8_t					TST_PublicExponent_E[TST_MAX_PUB_EXP_SIZE_IN_BYTES];
    DxUint8_t					TST_Modulus_N[TST_MAX_MOD_SIZE_IN_BYTES];
	DxUint8_t					TST_P[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2]; 
	DxUint8_t					TST_Q[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];  	   
	DxUint8_t					TST_dP[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint8_t					TST_dQ[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint8_t					TST_Qinv[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];		  	
    DxUint16_t					TST_KeySize;
    DxUint16_t					TST_DPSize; 
    DxUint16_t					TST_PubExponentSize; 
    DxUint16_t					TST_SaltLength;   
	DxUint8_t 					TST_input_hash_SHA1[CRYS_HASH_SHA1_DIGEST_SIZE_IN_BYTES];
	DxUint8_t 					TST_input_hash_MD5[CRYS_HASH_MD5_DIGEST_SIZE_IN_BYTES];	
    DxUint8_t 					TST_input_hash_SHA224[CRYS_HASH_SHA224_DIGEST_SIZE_IN_BYTES];
    DxUint8_t 					TST_input_hash_SHA256[CRYS_HASH_SHA256_DIGEST_SIZE_IN_BYTES];	
    DxUint8_t 					TST_input_hash_SHA384[CRYS_HASH_SHA384_DIGEST_SIZE_IN_BYTES];
    DxUint8_t 					TST_input_hash_SHA512[CRYS_HASH_SHA512_DIGEST_SIZE_IN_BYTES];	
	DxUint8_t 					TST_output_signiture[TST_MAX_PRVT_EXP_SIZE_IN_BYTES];	      
} TST_RSA_TestExtHashSignVerifyDataStruct;

typedef struct TST_RSA_TestGetKeyDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
    DxUint8_t					TST_PrivetExponent_D[TST_MAX_PRVT_EXP_SIZE_IN_BYTES];
	DxUint16_t					TST_PrivExponentSize; 
	DxUint8_t					TST_PublicExponent_E[TST_MAX_PUB_EXP_SIZE_IN_BYTES];
    DxUint16_t					TST_PubExponentSize; 
	DxUint8_t					TST_Modulus_N[TST_MAX_MOD_SIZE_IN_BYTES];
	DxUint16_t					TST_ModulusSize;
	DxUint8_t					TST_P[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint16_t					TST_pSize; 
	DxUint8_t					TST_Q[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];  	   
	DxUint16_t					TST_qSize; 
	DxUint8_t					TST_Dp[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint16_t					TST_DpSize; 
	DxUint8_t					TST_Dq[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint16_t					TST_DqSize; 
	DxUint8_t					TST_Qinv[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];		  	
	DxUint16_t					TST_QinvSize; 
} TST_RSA_TestGetKeyDataStruct;



/******** Public Variables ********/
/******** Public Functions ********/
/***************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_RSA_Acceptance_PRIME_EncDec 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for RSA primitive encrypt and decrypt					
 * 	This function Encrypts and Decrypts known vectors using RSA primitives
 *  Vector/Keys sizes used (in bits) - 512/1024/2048														
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:		
 *  1. Build the Private Key from external exponent and modulus
 *  2. Build the Public Key from External exponent and modulus
 *  3. Encrypt/Decrypt a known vector
 *  4. Compare the outputted result to the expected one					
 *
 **************************/								
CRYSError_t CRYS_ATP_TST_RSA_Acceptance_PRIME_EncDec ( void );

/***************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_RSA_Acceptance_PRIME_SignVerify 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for RSA primitive Sign & Verify					
 * 	This function signs and verifies known vectors using RSA primitives
 *  Vector/Keys sizes used (in bits) - 512/1024/2048														
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:		
 *  1. Build the Private Key from external exponent and modulus
 *  2. Build the Public Key from External exponent and modulus
 *  3. sign/verify a known vector
 *  4. Compare the outputted result to the expected one					
 *
 **************************/								
CRYSError_t CRYS_ATP_TST_RSA_Acceptance_PRIME_SignVerify ( void );

/***************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_RSA_Acceptance_PKCS1v15_EncDec 		
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for RSA PKCS1v15 encrypt and decrypt
 *  According to PKCS#1 Ver1.5
 *  Including RSA KeyGeneration
 * 	This function Encrypts and Decrypts known vectors
 *  Vector/Keys sizes used (in bits) - 512/1024/2048 also CRT private														
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:	
 *  1. Prepare keys	
 *     a. Generate keys 
 *     or
 *     a. Build the Private Key from external exponent and modulus
 *     b. Build the Public Key from External exponent and modulus
 *  2. Encrypt/Decrypt a known vector
 *  3. Compare the outputted result to the expected one					
 *
 **************************/								
CRYSError_t CRYS_ATP_TST_RSA_Acceptance_PKCS1v15_EncDec (int TST_KeyGeneration_TestStatus);

/***************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_RSA_Acceptance_PKCS1v15_NonIntegrate_SignVerify 		
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for RSA PKCS1v15 Sign & Verify					
 * 	This function Signs & Verify known vectors using RSA PKCS1v15
 *  Including RSA KeyGeneration
 *  Vectors sizes used (in byte) - 16/32/512														
 *  Key sizes used     (in bits) - 512/1024/2048
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:		
 *  1. Prepare keys	
 *     a. Generate keys 
 *     or
 *     a. Build the Private Key from external exponent and modulus
 *     b. Build the Public Key from External exponent and modulus
 *  2. Call the CRYS_RSA_PKCS1v15_SignInit to init the Sign operation
 *  3. Call the CRYS_RSA_PKCS1v15_SignUpdate - This function is called N times
 *                              		  (N = number of blocks in data each block is 16byte)
 *  4. Call the RSA_SignFinish to complete the sign operation
 *  5. Call the CRYS_RSA_PKCS1v15_VerifyInit to init the verification operation
 *  7. Call the CRYS_RSA_PKCS1v15_VerifyUpdate - This function is called N times
 *                              		  (N = number of blocks in data each block is 16byte)
 *  7.Call the CRYS_RSA_PKCS1v15_VerifyFinish to complete the verification operation			
 *
 **************************/
CRYSError_t CRYS_ATP_TST_RSA_Acceptance_PKCS1v15_NonIntegrate_SignVerify (int TST_KeyGeneration_TestStatus);

/***************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_RSA_Acceptance_PKCS1v15_Integrated_SignVerify 		
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for RSA PKCS1v15 Sign & Verify					
 * 	This function Signs & Verify known vectors using RSA PKCS1v15
 *  Vectors sizes used (in byte) - 16/32/512														
 *  Key sizes used     (in bits) - 512/1024/2048
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:		
 *  1. Prepare keys	
 *     a. Generate keys 
 *     or
 *     a. Build the Private Key from external exponent and modulus
 *     b. Build the Public Key from External exponent and modulus
 *  3. Call the CRYS_RSA_PKCS1v15_Sign to preform the Sign operation
 *  4. Call the CRYS_RSA_PKCS1v15_Verify to complete the verification operation
 *  5. Compare the outputted result to the expected one					
 *
 **************************/
CRYSError_t CRYS_ATP_TST_RSA_Acceptance_PKCS1v15_Integrated_SignVerify (int TST_KeyGeneration_TestStatus);

/***************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_RSA_Acceptance_PKCS1v15_ExternalHash_SignVerify 		
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for RSA PKCS1v15 Sign & Verify
 *  When the Hash for the Sign is preformed externally					
 * 	This function Signs & Verify hash vectors using RSA PKCS1v15
 *  Vectors sizes used (in byte) - SHA1 - 20, MD5 - 16														
 *  Key sizes used     (in bits) - 512/1024/2048
 * Algorithm:		
 *  1. Prepare keys	
 *     a. Generate keys 
 *     or
 *     a. Build the Private Key from external exponent and modulus
 *     b. Build the Public Key from External exponent and modulus
 *  2. Call the CRYS_RSA_PKCS1v15_SHA1_Sign or CRYS_RSA_PKCS1v15_MD5_Sign to preform the Sign operation
 *  3. Call the CRYS_RSA_PKCS1v15_SHA1_Verify or CRYS_RSA_PKCS1v15_MD5_verify to complete the verification operation
 *  4. Compare the outputted result to the expected one					
 *
 **************************/
CRYSError_t CRYS_ATP_TST_RSA_Acceptance_PKCS1v15_ExternalHash_SignVerify (int TST_KeyGeneration_TestStatus);

/***************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_RSA_Acceptance_OAEP_EncDec 		
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for RSA OAEP encrypt and decrypt
 *  According to PKCS#1 Ver2.1
 * 	This function Encrypts and Decrypts known vectors
 *  Vector/Keys sizes used (in bits) - 512/1024/2048														
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:		
 *  1. Prepare keys	
 *     a. Generate keys 
 *     or
 *     a. Build the Private Key from external exponent and modulus
 *     b. Build the Public Key from External exponent and modulus 		
 *  2. Encrypt/Decrypt a known vector
 *  3. Compare the outputted result to the expected one					
 *
 **************************/							
CRYSError_t CRYS_ATP_TST_RSA_Acceptance_OAEP_EncDec (int TST_KeyGeneration_TestStatus);

/***************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_RSA_Acceptance_PSS_NonIntegrate_SignVerify 		
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for RSA PSS PKCS#1v2.1 sign & Verify 					
 * 	This function  signs & Verifys known vectors using RSA PSS PKCS#1v2.1
 *  Vectors sizes used (in byte) - 16/32/512														
 *  Key sizes used     (in bits) - 512/1024/2048
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:		
 *  1. Prepare keys	
 *     a. Generate keys 
 *     or
 *     a. Build the Private Key from external exponent and modulus
 *     b. Build the Public Key from External exponent and modulus 	
 *  2. Call the CRYS_RSA_PSS_SignInit to init the Sign operation
 *  3. Call the CRYS_RSA_PSS_SignUpdate - This function is called N times
 *                              		  (N = number of blocks in data each block is 16byte)
 *  4. Call the RSA_SignFinish to complete the sign operation
 *  5. Call the CRYS_RSA_PSS_VerifyInit to init the verification operation
 *  6. Call the CRYS_RSA_PSS_VerifyUpdate - This function is called N times
 *                              		  (N = number of blocks in data each block is 16byte)
 *  7.Call the CRYS_RSA_PSS_VerifyFinish to complete the verification operation				
 *
 **************************/									
CRYSError_t CRYS_ATP_TST_RSA_Acceptance_PSS_NonIntegrate_SignVerify (int TST_KeyGeneration_TestStatus);

/***************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_RSA_Acceptance_PSS_Integrated_SignVerify 		
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for RSA PSS PKCS#1v2.1 sign & Verify 					
 * 	This function  signs & Verify known vectors using RSA PSS PKCS#1v2.1
 *  Vectors sizes used (in byte) - 16/32/512														
 *  Key sizes used     (in bits) - 512/1024/2048
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:		
 *  1. Prepare keys	
 *     a. Generate keys 
 *     or
 *     a. Build the Private Key from external exponent and modulus
 *     b. Build the Public Key from External exponent and modulus 	
 *  2. Call the CRYS_RSA_PSS_Sign to preform the Sign operation
 *  3. Call the RSA_PSS_Verify to preform the verification operation					
 *
 **************************/								
CRYSError_t CRYS_ATP_TST_RSA_Acceptance_PSS_Integrated_SignVerify (int TST_KeyGeneration_TestStatus);

/***************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_RSA_Acceptance_PSS_ExternalHash_SignVerify 		
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for RSA PKCS1v2.1 PSS Sign & Verify
 *  When the Hash for the Sign is preformed externally					
 * 	This function Signs & Verify hash vectors using RSA PKCS1v2.1 PSS
 *  Vectors sizes used (in byte) - SHA1 - 20, MD5 - 16														
 *  Key sizes used     (in bits) - 512/1024/2048
 * Algorithm:		
 *  1. Prepare keys	
 *     a. Generate keys 
 *     or
 *     a. Build the Private Key from external exponent and modulus
 *     b. Build the Public Key from External exponent and modulus 
 *  2. Call the CRYS_RSA_PSS_SHA1_Sign or CRYS_RSA_PSS_MD5_Sign to preform the Sign operation
 *  3. Call the CRYS_RSA_PSS_SHA1_Verify or CRYS_RSA_PSS_MD5_verify to complete the verification operation
 *  4. Compare the outputted result to the expected one					
 *
 **************************/
CRYSError_t CRYS_ATP_TST_RSA_Acceptance_PSS_ExternalHash_SignVerify ( int TST_KeyGeneration_TestStatus);

/***************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_RSA_Get_PrivAndPubKey      
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is an Acceptance test for RSA Get Privet Key and Get Public Key                  
 *  This function Generate a RSA key and get its privet\public key and
 *  compare it to the test vector
 *
 *  Key sizes used     (in bits) - 512/1024/2048
 *  This also outputs the results to an output buffer or the same input buffer
 * Algorithm:       
 *  1. Prepare keys 
 *     a. Generate keys 
 *     or
 *     a. Build the Private Key from external exponent and modulus
 *     b. Build the Public Key from External exponent and modulus
 *  3. Call the CRYS_RSA_Get_Privet_key to preform the Get operation
 *  4. Call the CRYS_RSA_Get_Public_key to preform the Get operation
 *  5. Compare the outputted result to the expected one                  
 *
 **************************/
CRYSError_t CRYS_ATP_TST_RSA_Get_PrivAndPubKey(int TST_KeyGeneration_TestStatus);

#ifdef __cplusplus
}
#endif

#endif


#endif

